//
// Referenced Polygon.js
//
//

function buildUI(obj){
    
    obj.setParameter("name","Referenced Polygon");

    obj.addParameterLink("target", false, false);

    obj.addParameterSelector("mirror", [ "none", "ZY", "ZX", "YX" ], true, true);

    obj.addParameterSeparator("Tool"); // 

    obj.addParameterButton("attach materials", "attach", "attachMaterials");
    
    obj.addParameterSeparator("Smooth"); // normal type
    obj.addParameterSelector("smooth",["flat","phong","constraint","normal break"],true,true);
    obj.addParameterFloat("smooth angle",45,1,180,true,true);

    obj.addParameterSeparator("Animation");
  
    obj.addParameterButton("update", "update", "updateObject");
    obj.addParameterFloat("timer", 0, 0, 10000, true, true);

    obj.setParameter("smooth", 2, false);
}

var attachLock = false;
var materialInfo;

function updateObject(obj) {

    obj.update();
}

function buildObject(obj){

    //print( "\n--\n--\n" );
    //print( 'build object:' + attachLock );

    if (attachLock) return;

    var target = obj.getParameter("target");

    if (!target) return;

    // smooth
    obj.setParameter("normalType",obj.getParameter("smooth"),false);
    obj.setParameter("normalAngle",obj.getParameter("smooth angle"),false);
    //

    var mirror = obj.getParameter("mirror");

    var targetMat = new Mat4D(TRANSLATE, 0, 0, 0); //target.objMatrix();
    var mat = new Mat4D(SCALE, 1, 1, 1);

    switch( mirror ) {
        case 1: // ZY
            mat = new Mat4D(SCALE, -1, 1, 1);
            break;
        case 2: // ZX
            mat = new Mat4D(SCALE, 1, -1, 1);
            break;
        case 3: // YX
            mat = new Mat4D(SCALE, 1, 1, -1);
            break;
    }

    var vertexIndexCount = 0;
    materialInfo = [];

    collectMaterialInfo( target );

    // debug
    /*
    for (var i = 0;i < materialInfo.length;i++) {
        var info = materialInfo[i];

        print( i + ':' );

        for (var j in info) {

            print( '  ' + j + ':' + info[j] );

            if (j == 'list') {
                for (var k in info.list) {
                    print( '    ' + k + ':' + info.list[k] );
                }
            }
        }
    }
     */

    copyPolygon( obj, vertexIndexCount, target, targetMat, mat, mirror );
}

function collectMaterialInfo( target ) {
    var tagCount = target.tagCount();

    if (target.family() == NGONFAMILY) {

        for (var i = 0;i < tagCount;i++) {
            var tag = target.tagAtIndex(i);

            //print( tag.type() + ' => ' + SHADERTAG );
            if (tag.type() == SHADERTAG) {
                var tagInfo = {};
                var tagInfoNames = [ 'tagOn', 'shadingSpace', 'tangentSpace', 'shadingRotation', 'shadingScale', 'shadingOffset', 'UVRotation', 'UVScale', 'UVOffset' ];
                for (var ti = 0;ti < tagInfoNames.length;ti++) {
                    tagInfo[ tagInfoNames[ti] ] = tag.getParameter( tagInfoNames[ti] );
                }

                var tagInfoLine = JSON.stringify( tagInfo );

                var shadeSelection = tag.getParameter("shadeSelection");
                var linkedMaterial = tag.getParameter("material");

                var isFound = false;
                for (var j = 0;j < materialInfo.length;j++) {
                    var info = materialInfo[j];

                    if (info.matId == linkedMaterial.id() && info.tagInfo == tagInfoLine) {
                        isFound  = j;
                    }
                }

                if (isFound === false) {
                    var info = {}
                    info[ 'o' + target.id() ] = [ shadeSelection ];
                    materialInfo.push( { "tagInfo": tagInfoLine, 'matId': linkedMaterial.id(), "list": info } );

                } else {
                    if (materialInfo[ isFound ].list[ 'o' + target.id() ]) {
                        materialInfo[ isFound ].list[ 'o' + target.id() ].push( shadeSelection );
                    } else {
                        materialInfo[ isFound ].list[ 'o' + target.id() ] = [ shadeSelection ];
                    }
                }
            }
        }

    }

    var childCount = target.childCount();
    for (var i = 0;i < childCount;i++) {
        var child = target.childAtIndex(i);

        collectMaterialInfo( child );
    }
}

function copyPolygon( obj, vertexIndexCount, targetRoot, targetMat, mat, mirror ) {

    //print( targetRoot.getParameter("name") + ':' + vertexIndexCount );

    if ( targetRoot.family() == NGONFAMILY ) {
        var targetCore = targetRoot.modCore();
        var core = obj.core();

        var vertexCount = targetCore.vertexCount();

        for (var i = 0;i < vertexCount;i++) {
            var vec = mat.multiply( targetMat.multiply( targetCore.vertex(i) ) );
            core.addVertex( false, vec );
        }

        var polygonCount = targetCore.polygonCount();
        var polygonInfo = [];

        for (var i = 0;i < polygonCount;i++) {
            var size = targetCore.polygonSize( i );
            var vertices = [];
            var uvs = [];

            for (var j = 0;j < size;j++) {
                vertices.push( targetCore.vertexIndex(i, j) + vertexIndexCount );
                uvs.push( targetCore.uvCoord(i, j) );
            }

            if (mirror > 0) {
                vertices.reverse();
                uvs.reverse();
            }
            polygonInfo.push( core.addIndexPolygon( size, vertices, uvs ) );
        }

        if (materialInfo.length == 1) { // single polygon
            var polySel = targetRoot.getParameter("activePolySelection");

            for (var i = 0;i < polygonCount;i++) {
                for (var j = 0;j < 24;j++) {
                    targetCore.setActivePolygonSelection(j);
                    core.setActivePolygonSelection(j);

                    core.setPolygonSelection(polygonInfo[i], targetCore.polygonSelection(i));
                }
            }

            targetRoot.setParameter("activePolySelection", polySel, false);
            obj.setParameter("activePolySelection", polySel, false);
        } else { // grouped objects
            var list = undefined;
            var linkedMaterialId = undefined;
            var polySelIndex = 0;

            for (var i = 0;i < materialInfo.length;i++) {
                var info = materialInfo[i];

                for (var j in info.list ) {
                    if (j == 'o' + targetRoot.id()) {
                        assignPolySel( core, targetCore, targetRoot, polygonInfo, info.list[j], info.matId, polySelIndex );
                    }
                }

                polySelIndex++;
            }

        }

        var edgeTypes = [ SELECT, UVPOINT, UVEDGE, UVPINNED, SEAM, CREASE ];

        for (var i = 0;i < polygonCount;i++) {
            var size = targetCore.polygonSize( i );

            for (var j = 0;j < size;j++) {

                for (var k = 0;k < edgeTypes.length;k++) {

                    core.setEdgeSelection( polygonInfo[i], j, edgeTypes[k], targetCore.edgeSelection(i, j, edgeTypes[k]) );

                }
            }
        }

        vertexIndexCount += vertexCount;
    }

    var childCount = targetRoot.childCount();

    for (var i = 0;i < childCount;i++) {
        var child = targetRoot.childAtIndex(i);

        if (child.family() != MODIFIERFAMILY) {
            var childMat = targetMat.multiply( child.objMatrix() );
            vertexIndexCount = copyPolygon( obj, vertexIndexCount, child, childMat, mat, mirror );
        }
    }

    return vertexIndexCount;
}

function assignPolySel(core, targetCore, targetRoot, polygonInfo, list, linkedMaterialId, polySelIndex) {

    var polygonCount = targetCore.polygonCount();

    //print('set materialId:' + linkedMaterialId + ' -> ' + polySelIndex + ' for ' + targetRoot.id() + ' with ' + list);

    var polySel = targetRoot.getParameter("activePolySelection");

    for (var i = 0;i < list.length;i++) {
        var targetPolySel = list[i] - 1;
        var corePolySel = polySelIndex;

        if (corePolySel > 23) corePolySel = 23;

        if (targetPolySel > -1) {
            for (var j = 0;j < polygonCount;j++) {
                targetCore.setActivePolygonSelection(targetPolySel);
                core.setActivePolygonSelection(corePolySel);

                core.setPolygonSelection(polygonInfo[j], targetCore.polygonSelection(j));
            }
        } else {
            for (var j = 0;j < polygonCount;j++) {
                core.setActivePolygonSelection(corePolySel);

                core.setPolygonSelection(polygonInfo[j], true);
            }
        }
    }

    targetRoot.setParameter("activePolySelection", polySel, false);
}


function attachMaterials( obj ) {

    var st1 = new Date().getTime();

    var target = obj.getParameter("target");

    if (!target) return;

    var doc = obj.document();

    attachLock = true;

    doc.retainRedrawLock();

    // remove shader tag
    for (var i = obj.tagCount()-1;i >= 0;i--) {
        var tag = obj.tagAtIndex(i);
        if (tag.type() == SHADERTAG) {
            obj.removeTag(tag);
        }
    }

    var st2 = new Date().getTime();
    printElapsedTime('all tags removed:', st2-st1);

    for (var i = 0;i < materialInfo.length;i++) {
        var info = materialInfo[i];
        
        var tagInfo = JSON.parse( info.tagInfo );
        var matId = info.matId;
        var material = undefined;

        for (var j = 0;j < doc.materialCount();j++) {
            var mat = doc.materialAtIndex(j);
            if (mat.id() == matId) {
                material = mat;
            }
        }

        var newTag = obj.addTagOfType( SHADERTAG );

        for (var j in tagInfo) {
            var info = tagInfo[j];

            if (info.z !== undefined) {
                newTag.setParameter(j, new Vec3D( info.x, info.y, info.z ), false);
            } else if (info.y !== undefined) {
                newTag.setParameter(j, new Vec2D( info.x, info.y ), false);
            } else {
                newTag.setParameter(j, tagInfo[j], false);
            }
        }

        if (material !== undefined) newTag.setParameter("material", material, false);

        newTag.setParameter("shadeSelection", i + 1, false);

        var st2 = new Date().getTime();
        printElapsedTime('tag ' + i + 'added:', st2-st1);
    }

    doc.releaseRedrawLock();

    attachLock = false;

    obj.update();

    var st2 = new Date().getTime();
    printElapsedTime('update finished:', st2-st1);

}

function printElapsedTime(label, time) {
    if (time/1000 > 60) {
        //print( label + ':' + (time/1000).toFixed(2) + 'sec(s) ( ' + Math.floor(time/1000/60) + '.' + Math.floor((time/1000)%60) + ' )');
    } else {
        //print( label + ':' + (time/1000).toFixed(2) + 'sec(s)' );
    }
}
